Review

# A Systematic Review of the Hydrological, Environmental and Durability Performance of Permeable Pavement Systems

Mariacrocetta Sambito $^ { 1 , * \oplus }$ , Alessandro Severino $^ 2 \textcircled { | | }$ , Gabriele Freni $^ 3 \textcircled { \scriptsize { \parallel } }$ and Larysa Neduzha $^ 4 \textcircled { | | }$

Academic Editor: Mayca Rubio-Gámez

1 Department of Engineering, University of Palermo, Viale delle Scienze, Ed. 8, 90100 Palermo, Italy   
2 Department of Civil Engineering and Architecture, University of Catania, 95123 Catania, Italy; alessandro.severino@unict.it   
3 School of Engineering and Architecture, University of Enna “Kore”, 94100 Enna, Italy; gabriele.freni@unikore.it   
4 Department of Theoretical and Structural Mechanics, Dnipro National University of Railway Transport Named after Academician V. Lazaryan, Lazaryan St. 2, 49010 Dnipro, Ukraine; nlorhen@i.ua   
Correspondence: mariacrocetta.sambito@unipa.it

Received: 26 March 2021   
Accepted: 16 April 2021   
Published: 18 April 2021

Publisher’s Note: MDPI stays neutral with regard to jurisdictional claims in published maps and institutional affiliations.

Abstract: Due to urbanization, large portions of vegetated territory have been replaced by waterproof surfaces. The consequences are greater outflows, lower infiltration, and lower evapotranspiration. Pavement systems made with permeable surfaces allow the infiltration of water, ensuring reduction of runoff volume. In this paper, the methods of analysis of the hydrological and environmental performance of the pavement systems are reviewed in the context of urban drainage and regarding their durability. The purpose is to present an overview of the studies published during the last decade in the field. The Pubmed and Web Science Core Collection electronic databases were used to conduct the scientific literature survey. This generated 1238 papers, of which only 17 met the criteria and were included and discussed in this review. The evidence drawn from the knowledge on which the document is based provides useful critical interpretations of existing studies to progress the current understanding on hydrological performance and environment impacts in terms of conventional pollutant removal efficiency and the current permeable pavement systems.

Keywords: hydrological performance; peak flow; permeable pavement systems; pervious concrete; runoff pollution; water quality

# 1. Introduction

A critical design objective for urban rainwater management is the protection of flow paths and natural water balances. Achieving this goal is aimed at preventing and mitigating disruptions in natural processes, which in turn contributes to making flow systems unhealthy. New planning techniques and engineering systems can help in the economic, environmental, cultural, and social impacts associated with urban stormwater. An increasingly accepted approach to address the challenges of stormwater design and management is the implementation of so-called LID (low impact development). This represents a design philosophy that encompasses planning methods and rainwater-management technologies in order to reduce as much as possible the negative impacts deriving from urban rainwater, such as the degradation of the quality of underground and surface water, the loss of recharge and aquatic biodiversity, floods, and erosion [1,2]. Rainwater management is also important regarding the pollutants it carries deriving from anthropogenic activities and environmental processes. For example, the suspended materials from vehicular traffic, tire wear, and oil and gas leaks from vehicles are deposited on pavements, and all of this material is carried by rainwater and infiltrates between the surface of permeable pavement and the other base layers, accumulating over time. The pollutants most detected are total suspended solids (TSS), metals, hydrocarbons, chlorides, bacteria, and nutrients. Furthermore, particular attention must be paid to the discharge of excess nutrients into water bodies as they cause the seasonal eutrophication and algal proliferation phenomena. In fact, high levels of nu-loads carried by rainwater. In fact, several researchers have studied PPS' purify trients such as phosphorus cause increased growth of phytoplankton, providing a toxicResearchers have reproduced PPS in the laboratory and studied their remova environment for aquatic animals. Parameters such as temperature andon conventional pollutants present in surface runoff. High l $\mathrm { p H }$ are very impor-ls of removal tant and for this reason they are often measured, as they influence the toxicity and solubility of some parameters, such as heavy metals. Permeable pavement systems (PPS) can be a valid strategy to control the polluting loads carried by rainwater. In fact, several researchersleum, biochemical oxygen demand (BOD), chemical oxygen demand (COD), have studied PPS’ purifying effects. Researchers have reproduced PPS in the laboratory and(NH3), and total phosphorus (TP). Conversely, low efficiencies were found in studied their removal efficiency on conventional pollutants present in surface runoff. Highasphalt pavement for the removal of chloride (Cl) and total nitrogen (TN). In levels of removal have been found for heavy metals; however, PPS has also been foundmeable ceramic brick can effectively purify TSS and TP with values around 79 to effectively remove petroleum, biochemical oxygen demand (BOD), chemical oxygen demand (COD), ammonia (NH3), and total phosphorus (TP). Conversely, low efficiencies were found in permeable asphalt pavement for the removal of chloride (Cl) and total nitrogen (TN). Instead, permeable ceramic brick can effectively purify TSS and TP with valuessive view of the sources is mandatory; several studies have attempted to identi aroundsources $7 9 \%$ and for $7 4 \%$ , respectively, but it is not very efficient in the removal of BOD, NH3,lution in urban systems [3]. Understanding what the sourc and TN. However, for the reliable removal of hazardous substances via permeable pave-reducing them is an indirect way of improving the durability in terms of perm ments a more intensive view of the sources is mandatory; several studies have attempted tothe PPS. Additionally, like in many fields of environmental management, a c identify what the sources are for pollution in urban systems [3]. Understanding what the sources are and reducing them is an indirect way of improving the durability in terms of permeability of the PPS. Additionally, like in many fields of environmental management, a combination of different measures at different locations has the most powerful effect. Thelution of freshwater systems [4,5]. If these measures were implemented at u measures implemented in agricultural/rural landscapes were found to be useful to preventthere would be the possibility of preventing the transportation of harmful the pollution of freshwater systems [4,5]. If these measures were implemented at urbanwhose source is not the pavement itself. sites, there would be the possibility of preventing the transportation of harmful substancesThis review provides a summary of the current state of the art (from 2010 whose source is not the pavement itself.

This review provides a summary of the current state of the art (from 2010 to date) of knowledge acquired on permeable pavement systems. There are highly variable eval-tions and study methods on PPS; therefore, this review has the additional uations and study methods on PPS; therefore, this review has the additional purpose ofproviding a critical interpretation of the analyzed studies in order to impro providing a critical interpretation of the analyzed studies in order to improve currentknowledge on hydrological and environmental performance. Finally, in order t knowledge on hydrological and environmental performance. Finally, in order to high-the importance of these factors on the durability and functionality of a perme light the importance of these factors on the durability and functionality of a permeable pavement, a short paragraph on the main factors that determine the loss of its functional objectives has been provided. In Figure 1, an example of the profiles of the underground layers of three types of permeable pavement systems is provided.layers of three types of permeable pavement systems is p

![](images/6141cf9a70a0e412f1aa9dbfe0e2f259df104903e50be994105fec1e1f8d7b5e.jpg)  
Figure 1. Porous paver, pervious concrete, and porous asphalt section, respectively.

# 2. Materials and MethodsFigure 1. Porous paver, perv

An electronic search was conducted in the Pubmed and Web Science Core Collection databases, filtering the results by English language and publication date, from 2010 to date.2. Materials and Methods The search included keywords related to pavement systems, and their environmental andAn electronic search was conducted in the Pubmed and Web Science Core Collection hydrological aspects and the durability associated with them (see Table 1).databases, filtering the results by English language and publication dat

Table 1. Keywords used in research strategy.tal and hydrological aspects and the du   

<html><body><table><tr><td colspan="3">Search Field</td></tr><tr><td>#1</td><td>Permeable pavement systems</td><td>permeable pavement, pervious pavement, porous pavement</td></tr><tr><td>#2</td><td> Environmental aspects</td><td> peak flow, rainfall volume</td></tr><tr><td>#3</td><td> Hydrological aspects</td><td> runoff pollution, water quality</td></tr><tr><td>#4</td><td>Durability aspects</td><td>d</td></tr><tr><td>#5</td><td>Combinations</td><td>#1 and #2;#1 and #3;#1 and #4;#1,#2,#3 and #4</td></tr></table></body></html>

Research on existing literature over the past decade produced a total of 1238 papers.Research on existing literature over the past decade produced a total of 1238 papers. Since more than one database was used, the search returned some identical documents, soSince more than one database was used, the search returned some identical documents, before anything else, it was necessary to remove the duplicates; there were 205 of these.so before anything else, it was necessary to remove the duplicates; there were 205 of these. Subsequently, through the use of Rayyan Review, it was possible to evaluate and selectSubsequently, through the use of Rayyan Review, it was possible to evaluate and select the titles and abstracts of 1033 papers using two external reviewers and using a third forthe titles and abstracts of 1033 papers using two external reviewers and using a third for the documents on which they disagreed. Therefore, referring to the focus of the study, athe documents on which they disagreed. Therefore, referring to the focus of the study, a further 957 papers were discarded as being not pertinent. Consequently, on only 76 papersfurther 957 papers were discarded as being not pertinent. Consequently, on only 76 paper was a complete analysis of the entire study carried out, and of these, another 59 paperswas a complete analysis of the entire study carried out, and of these, another 59 paper were eliminated because they were (1) unrelated, (2) papers that report the same resultswere eliminated because they were (1) unrelated, (2) papers that report the same result as previous studies, or (3) reviews on past literature (for more information, please seeas previous studies, or (3) reviews on past literature (for more information, please see the the supporting information file). In total, 17 documents were taken into considerationsupporting information file). In total, 17 documents were taken into consideration for this for this review, as they were the only ones to meet all of the above criteria (language,review, as they were the only ones to meet all of the above criteria (language, publication publication date, originality, and relevance to the theme of the review). The main resultsdate, originality, and relevance to the theme of the review). The main results are presented are presented in Table 2 for the hydrological performance, in Table 3 for the removalin Table 2 for the hydrological performance, in Table 3 for the removal efficiency of conefficiency of conventional pollutants, and in Table 4 for observations on the durability ofventional pollutants, and in Table 4 for observations on the durability of the functional the functional objectives of the PPS. Figure 2 shows a flowchart of the process of recruitingobjectives of the PPS. Figure 2 shows a flowchart of the process of recruiting elected pa elected papers for systematic review.pers for systematic review.

![](images/cf3ada903f029daa6940811a45596b5e4d4c730e808563c4dceb942305eb6ead.jpg)  
Figure 2. Figure 2. Flow chart of the evolution of the strategic research carried out on the literature. Flow chart of the evolution of the strategic research carried out on the literature

# 3. Results

# 3.1. Hydrological Performance of PPS

In order to fully define the hydrological characteristics of a PPS, it should be monitored in a series of specific conditions such as in storm events of varying intensity and duration and in different antecedent and seasonally variable conditions. The geological and climatic conditions and the age conditions of a pavement, as well as differences in the design of PPS (such as boundary conditions and insufficient drainage) influence the hydrological results and are therefore fundamental to the comparison of performance.

A valid tool is provided by the statistical analyses that report the findings in terms of statistically significant differences compared to the “control graphs” [6,7].

Through the monitoring, it was possible to expand the number of monitorable hydraulic parameters and conduct an analysis of the timing and duration of the flow, registering a reduction in volume and peak flow [8]. The same result is recorded in simulations.

Several studies, analyzing different aspects, demonstrate the variability of volumes and peak flow [1]. Other studies have found that PP systems do not generate outflow for minor events preceded by dry antecedent conditions [9,10].

Although surface runoff volumes are usually lower in permeable pavements rather than asphalt ones, sometimes increases in runoff are possible (i.e., negative volume reductions), as it may happen that rainwater previously stored in a PP system is released during an event [11].

A study of interlocking permeable concrete pavement (PICP) on low-permeability soils in New Zealand [7] found greater than expected reductions in runoff volume; the authors suggested that the most probable explanation could be given by hydrological losses, such as the phenomenon of evaporation, and/or by the possible presence of fractures within the underlying soils. Some studies [12–14] have found that the increase in evaporation rates in PP is a function of basic materials, as well as the vegetation and the color of the stone.

Both laboratory and field tests are important for hydraulic performance. Sometimes, laboratory-scale studies can complement those carried out in the field to evaluate the hydraulic properties of PP, but it is important to use well-defined and controlled conditions.

Furthermore, studies can also be conducted outdoors to investigate evapotranspiration processes that require exposure to natural conditions, but measuring instruments, such as lysimeters, are not easily installed on a large scale [12]. The study conducted by Hou et al. [13] included a low-conductivity soil layer as a boundary condition for the PP samples. On the contrary, the drainage of pavement samples in outdoor collection systems does not exactly replicate the performance of PP and is therefore not realistic. Others simulated a rain event and saw that exfiltration water continued to flow out of the soil layer for up to 10 days after the event.

These differences in observations between studies highlight the problem of the absence of a standard method; furthermore, the estimation of soil properties based on small soil samples can drastically undervalue mass hydraulic conductivity.

In order to provide a clear and concise framework on the current state of the art on hydrological performance of pavement systems, a systematic description of the main results obtained from the studies of the papers selected for this review has been reported in Table 2.

Table 2. Hydrological performances of permeable pavement systems.   

<html><body><table><tr><td>Type of Pavement</td><td></td><td>Main Findings</td><td>References</td></tr><tr><td>Pervious concrete JW Eco-technology pavement</td><td>.</td><td>The permeability at the center locations of PC showed no significant loss of permeability; on the contrary, there was a significant reduction of permeability at the corner and edge areas. JW pavement maintained more than 50% of its capacity when half of the aqueducts were fully blocked.</td><td>[7]</td></tr></table></body></html>

Table 2. Cont.   

<html><body><table><tr><td colspan="2">Type of Pavement</td><td>Main Findings</td><td>References</td></tr><tr><td>Concrete grid pavers Pervieus enteriocking concrete pavements</td><td>. .</td><td>SRV was &lt;1% of rainfall volume; exfiltrate volume reductions averaged 6be for CGP.</td><td>[5]</td></tr><tr><td>concrete pavers Pervious concrete Permeable interlocking</td><td></td><td>Microconditions throughout the pavement have a confounding influence on the overall effectiveness of maintenance. The impact of maintenance may be improved by establishing regular cleaning intervals and developing instructional guidelines for pavement</td><td>[8]</td></tr><tr><td>Permeable pavements</td><td></td><td>owners and equipment operators.</td><td>[2]</td></tr><tr><td>Porous pavement</td><td></td><td>The scenario with very high levels of BMPs and LID practice adoption reduced runoff volume and pollutant loads from 26.47% to 60.98% and provided the greatest reduction in runoff volume and pollutant loads among all scenarios. The L-THIA-LID 2.1 model is a valid tool that can be applied to various</td><td>[1]</td></tr><tr><td>Permeable pavement Porous concrete</td><td></td><td>scales. The results showed that the average time to runoff for permeable pavements under low-intensity rainfall scenarios was approximately 78.5 min, while this was shortened to only 51.5 min under high-intensity rainfall scenarios. respectively, but runoff retention performances were relatively greater in the</td><td>[15]</td></tr><tr><td>Permeable interlocking concrete pavements</td><td></td><td>runoff retention percentages. Results show that the annual total volume reduction rates of PICP using cement-stabilized crushed stones and PICP-crushed stones are 37.0% and 38.7%,respectively. The peak flow reduction rate and the time to the peak</td><td>[16]</td></tr></table></body></html>

PCIP, permeable interlocking concrete pavements; CGP, concrete grid pavers; PA, porous asphalt; PC, pervious concrete; PF, peak flow; PP, permeable pavement; RV, rainfall volume; SRV, surface runoff volume; LID, low-impact development; BMP, best management practices.

# 3.2. Environmental Performances

Permeable pavement systems, unlike conventional pavement, can reduce the amount of pollutants transported by rainwater and therefore decrease the total quantity of pollutants delivered to the receiving water bodies (Figure 3). This is an important aspect, and many researchers have focused on the quality of surface water in receiving water bodies, but the problem of contamination also affects groundwater. In fact, many permeable pavement systems allow the partial or total exfiltration of contaminants to the deeper layers of the pavement, where there may be the presence of underground aquifers [17]. Another very common aspect is the use of the mean concentration of events (EMC) as a means of estimating the impact on water quality of common contamination index parameters (e.g., TSS, TN, TP, etc.) or, alternatively, the percentage reduction of the total concentration of contamination [18,19]. However, although they can be useful tools for a rapid analysis of the performance of the PP, they are not suitable for giving detailed information on the real action carried out by the pavement. Each type of PP related to each specific contaminant analyzed has a different removal mechanism, therefore evaluating, in a single analysis, different types of contaminants all together does not give clear answers on the pavement’s removal efficiency and also makes this efficiency susceptible to large variations in function in the contaminated water sample tested. For example, samples of water with high percentages of chloride will give rise to very low PP efficiencies, as this is generally not retained; the same PP exposed to a different water sample (with a lower concentration of non retained contaminants) will give rise to higher efficiencies. Furthermore, if what is tested upstream is unknown, it is not possible to ascertain its removal downstream. Therefore, although some studies have done so [15], much of the published research doesEVIEW 7 of 12 not provide a characterization of the contamination matrix.

![](images/8a8b34739c6e3e17b9cbb8dfcf374f74454d0d0f69fb6ca91b49f94bc21e9d1c.jpg)  
Figure 3. Mechanism of absorption of contaminants and consequent partial removal through the PPS.Figure 3. Mechanism of absorption of contaminants and consequent partial removal through the PPS.

ble 3. Removal efficiency of permeable pavement systems.Other studies instead [16,20] record important reductions (even over $5 0 \%$ ) of conservative contaminants such as heavy metals, but in many cases, rainwater was tested for an insufficient number of events and as independent studies, meaning that these experiments results provide only limited reliability.

Liu et al. [21] observed a positive linear relationship between the thickness of the gravel he removal of pollutants from runoff.layer and the removal of pollutants TSS and TP from permeable pavement runoff. However, with the reported results, the nitrogen-removal performance of permeable pavements is highly variable and inconsistent [22].

had little effect on the removal of TP from runoff.Due to the biogeochemical complexity of the nitrogen species and the treatment mechanisms within the permeable pavement structure (including filtration, adsorption, he various levels and combinations of BMPs/LID practices reduced TN by ion exchange, and biological transformation), its removal is poorly understood.

Among the insignificant pollutants in PP effluents are extractable solvents (oil and grease), PAHs, and petroleum hydrocarbons. In fact, levels below the detection limits have unoff pollutant load reduction ratbeen constantly detected [23].

able bricks and porous concretes. While the gravel layer thickness in-In recent times, increased attention in the published scientific literature has been reased from 10 to 20 cm, runoff pollutant load reduction rates of TSS, TN,  [15]directed to nutrients, as high levels in rainwater cause excessive eutrophication, which has nd TP were highly enhanced. Higher TSS, TN,a negative consequence on water bodies.

re found from the lower intensity rainfalls.Another problem lies in the remobilization of certain elements over time. The phoshree field swales were monitored during a range of synthetic runoff events phorus present in the air, as particulate matter, and often conducted by atmospheric agents o determine their stormwater pollutant removal performances.on pavements, is retained by the PP but is released in the long term. The use of systems esults verified a distinctive exponential decrease of TSS concentration along inside the PP that can remove certain contaminants in order to avoid this problem can be he grass swale and demonstrated that between 50% and 75% of the TSS was useful. In this regard, laboratory studies have been carried out using geotextiles, demonemoved within the first 10 m of the swale length. Beyond 10 m, only a further strating that they could have a positive effect on the removal of some nutrients [21]. It is also important to investigate the source of the contamination, as it gives answers if, for otal phosphorus load was reduced by nearly 20 percent for PICP and PA, example, the inefficiency of a pavement is due to the pavement itself or to an exceptional cause. In fact, in one study it was observed that the sand detected in the samples taken downstream of the pavement were not due to its inefficiency but to a continuous spill of litter sand directly into the drainage pipes [20].

Overall, therefore, in order to define the real efficiencies in removing contaminants from permeable pavements and their environmental impact on water quality, further efforts must be made on the characterization and source of the contamination.

In terms of the first keyword in Table 1, Table 3 provides a concise description of the main results obtained from the studies of the selected papers concerning the impact of permeable pavement systems on water quality.

Table 3. Removal efficiency of permeable pavement systems.   

<html><body><table><tr><td>Type of Pavement</td><td>Main Findings</td><td>References</td></tr><tr><td>Porous asphalt Porous concrete Cementc brick Sand base brick Shale brick</td><td>efficiency of pollutants greatly and have different effects on certain pollutants. Furthermore, physical interception and adsorption would be the main mechanism for the removal of pollutants from runoff. NH4-N and TN can be easily removed by porous asphalt due to the high content of organic matter. By lacking useful adsorption sites,all the surface materials had little effect on the removal of TP from runoff.</td><td>The results indicate that surface materials influence the removal [19]</td></tr><tr><td>Porous pavement</td><td></td><td>The various levels and combinations of BMPs/LID practices reduced TN by 0.30 to 34.20%,TP by 0.27 to 47.41%,TSS by 0.33 to 53.59%,Pb by 0.30 to 60.98%, BOD by 0 to 26.70%,and COD by 0 to 27.52%.</td></tr><tr><td>Permeable pavement Porous concrete</td><td>Runoff pollutant load reduction rates of TSS,TN,and TP were varied titwens permeable riks nd pocm,ronfrps Whilethe grauel layer rates of TSS,TN,and TP were highly enhanced.Higher TSS,TN,and TP pollutant load removals were found from the lower intensity rainfalls.</td><td>[15]</td></tr><tr><td>. Permeable pavement</td><td>Three field swales were monitored during a range of synthetic runoff events to determine their stormwater pollutant removal performances. Results verified a distinctive exponential decrease of TSS concentration along the grass swale and demonstrated that between 5O% and 75% of the TSS was removed within the first 10 m of the swale length. Beyond 10 m,only a further approximately 20% reduction can be expected, regardless of the total length.</td><td>[18]</td></tr><tr><td>Permeable interlocking concrete pavers Pervious concrete Porous asphalt</td><td>Total phosphorus load was reduced by nearly 20 percent for PICP and PA,and 43 percent for PC.These values were likely tempered by the export of dissolved phosphorus observed in PICP and PA but not PC. Average removal eficiencies for metals were 40,42,and 49 percent in PA, PICP,and PC,respectively. A median pH of 10.2 in PC effluent could explain the elevated removal efficiency of phosphorus and select metals in PC over PICP and PA (median = 7.5 and 7.8, respectfully) through enhanced precipitation.</td><td>[20]</td></tr><tr><td>concrete pavements Permeable interlocking</td><td>PICP using cement-stabilized crushed stones has better transformation efficiency on NH4+-N in comparison to PICP crushed stones, and the release of NO3--N occurs in both PICPs. Moreover, the first type of PICP has lower effluent concentrations than PICP2 on pollutants like TSS, TP, PP, and DP.The PICP with cement-stabilized crushed stones as a base course is helpful to improve the hydrological performance and water quality of the effluent.</td><td>[16]</td></tr></table></body></html>

PCIP, permeable interlocking concrete pavements; CGP, concrete grid pavers; PA, porous asphalt; PC, pervious concrete; PF, peak flow; PP, permeable pavement; TN, total nitrogen; TP, total phosphorus; TSS, total suspended solids; Pb, lead; BOD, biochemical oxygen demand; COD, chemical oxygen demand.

# 3.3. Durability of Hydrological and Environmental Performance of PPS

There are several reasons why a PPS may not meet its functional goals during its useful life. One of the most critical conditions is the loss of its permeability; if the pavement loses its permeability, it will not be able to pursue the main hydrology and water quality objectives.

Age also affects the dynamic mechanisms of pollutant removal, such as absorption [24,25]. This paragraph presents a brief description of the main factors that reduce the durability of hydrological performance and water quality.

Regarding permeability, PP works like a filter and, as such, particle filtration decreases the pavement’s ability to infiltrate water over time. This process has been documented by numerous authors, and all of them stress that the effects of the clogging of permeability should be reversible by applying regular maintenance [26,27].

The reduction of the surface permeability of a PPS has a double effect. In the first place, if rainwater does not infiltrate at the same speed as precipitation, the formation of surface runoff and stagnation will be inevitable. Secondly, if the PPS behaves like an impermeable surface, all environmental benefits, including the reduction of pollutant loads, volumes, and flow peaks, are lost. To prevent and mitigate this result, maintenance is the most important strategy; removal of the clogging material before the hydrological and water quality functions of the system are significantly inhibited is essential.

The factors that contribute to the clogging of permeable pavements are many. Traffic is one of them; higher traffic rates lead to higher levels of permeability loss [28]. In other cases, it has been observed that the insertion of geotextiles can prevent infiltration and therefore reduce the permeability requirement of the pavement [29]. In cold climates, following winter maintenance (even a single winter is enough), the floors are smooth, and this leads to a drastic loss of permeability. This shows that the performance of permeable pavements should also be correlated to the climatic conditions of the areas in which they are installed [30]. However, it was found that, in the winter seasons when the temperature drops below zero, the PPS were able to promptly drain the water and therefore it was not present within the storage volume.

Conversely, rainwater exfiltration often causes higher humidity levels in the underlying soils, which increases the latent heat of the soil and postpones freezing within the pavement. Furthermore, the thawing processes are accelerated by the infiltration of meltwater from the surface [31].

Finally, the probability of remobilization has important repercussions for the likely contamination of groundwater systems. Many studies have observed that most pollutants are captured close to the pavement surface and in the first few centimeters of the porous medium [32]. Therefore, in terms of water quality goals, PPs are much more likely to fail due to surface obstruction than due to storage depletion.

Table 4 contains a brief description of the main results obtained by the selected papers in relation to long-term performance.

Table 4. Durability of permeable pavement systems.   

<html><body><table><tr><td>Type of Pavement</td><td></td><td>Main Findings</td><td>References</td></tr><tr><td rowspan="2"> Permeable iterloking</td><td>.</td><td>For every 6 mm of rain, clogging advanced 1 mm across the surface. The</td><td rowspan="2">[24]</td></tr><tr><td></td><td>characteristics are effective factors on rate and progression of clogging.</td></tr><tr><td rowspan="2">Pervious Concrete</td><td></td><td>Pervious concrete prepared with a smaller aggregate fraction is more prone to clogging.</td><td rowspan="2">[26]</td></tr><tr><td></td><td>Regarding the influence of UBC,it is important to find a balance between pervious concrete infiltration and UBC exfiltration rate, particularly in a case of pervious concrete flags made of coarse aggregate.</td></tr></table></body></html>

Table 4. Cont.   

<html><body><table><tr><td colspan="2">Type of Pavement</td><td>Main Findings</td><td>References</td></tr><tr><td>Permeable pavement</td><td>.</td><td>The PP showed 100%,23%,and 59% efficiencies in sediment retention (TSS removal), (PO4-3),and N-NH4+ removal during the entire study, respectively. This study demonstrated that, when PPs are annually cleaned using proper maintenance, it is expected that PPs can function hydraulically and be able to remove particulate pollutants throughout their lifespan.</td><td>[27]</td></tr><tr><td>Permeable pavement</td><td></td><td>Two falling-head test methods are recommended: one applies Darcy&#x27;s law and determines hydraulic conductivity in the conventional way; another measures the time history of falling head and calculates hydraulic conductivity using a modified Darcy equation. It is also highlighted that the measurement of hydraulic conductivity offers a convenient platform for assessing the durability of a permeable pavement against clogging.</td><td>[25]</td></tr><tr><td>Porous asphalt</td><td>.</td><td>Porous asphalt mixture with an aggregate skeleton is especially suitable for permeable pavements in rainy regions.</td><td>[30]</td></tr><tr><td>Permeable pavement</td><td></td><td>Experimental data suggested that a living biofilm developed on a nonwoven polypropylene and polyethylene geotextile can be efficient in the removal of mercury ions from contaminated urban and industrial runoff.</td><td>[29]</td></tr><tr><td>Permeable asphalt pavement</td><td></td><td>Permeable asphalt pavement should be selected according to the rainfall characteristics of the project site,so as to improve the permeable performance and ensure the bearing capacity of the pavement structure. The results show that, under the rainfall conditions in in the central plains urban agglomeration of China, there is no surface runoff on the permeable asphalt pavement with a 120 mm drainage surface layer, which is suitable for the medium-traffic grade of urban roads with cumulative equivalent axle loads of 10 million to 12 million times.</td><td>[28]</td></tr></table></body></html>

PCIP, permeable interlocking concrete pavements; CGP, concrete grid pavers; PA, porous asphalt; PC, pervious concrete; PF, peak flow; PP, permeable pavement; UBC, unbound base course.

# 4. Discussion

Through the research carried out for this study, it was possible to observe that, in many cases, the results of the studies conducted are discordant with those expected and the authors often found themselves formulating hypotheses to provide an explanation without any proof. In other cases, however, studies conducted on the same aspect and on the same type of PP provide completely different results. This latest evidence emphasizes a very important aspect, namely, the absence of a standard or well-defined method for the evaluation of permeable pavement systems. There is no standard that excludes as many unrealistic boundary conditions as possible or that underestimates some aspects, and this leads to very conflicting results.

To give some examples, it is clear that the absence of an exact indication of the reproduction of precipitation events for the evaluation of the disposal capacity of the PP runoff volumes or, more generally, of their hydrological performance, has led many authors to conduct studies to underestimate conditions (number of reproduced events fewer than 5) or unrealistic (the events in the same sample have no correlation with each other and are independent), making their results automatically unreliable. Others reveal the absence of a consistent percentage of volumes of water disposed of by evapotranspiration or other hydrological phenomena without providing any certainty since their studies are conducted in the laboratory, and the climatic conditions cannot be faithfully reproduced in reality. Some overcome this obstacle by moving outdoors; however, even in that case some criticalities were found. In those cases, in fact, often the study was focused on a too-small portion of land; at other times it neglected the boundary conditions of the sample analyzed, or they were not accurate, and at other times, difficulties were encountered, as some instruments cannot be easily brought into the field.

In 2013, Drake et al. [33] provided an important review on the issue, advising to change the direction the research was aiming for because it would not lead to the achievement of reliable results. At present, the situation has not changed; many studies still aim to contribute by proposing further new methods or by reproducing studies to scale with the same simplifying hypotheses that distort the reliability of the results, and little or no effort is concentrated on a study with, for example, a longer analysis time than on average done so far, conducted outdoors, and exposed to real climatic and anthropic conditions, a study that certainly may have its criticalities but which at least exceeds those already discussed and consolidated in the past.

In general, laboratory studies, whether they are to evaluate the hydrological or environmental performance, neglect many aspects including the climatic conditions that we have already mentioned, the dry-wet conditions cycles to which they are naturally subjected, vehicle traffic loads, chemical inputs, and even the growth of biofilms or surface crusts that reduce their permeability. Another important aspect is the reproduction of reliable precipitation events. To this end, precipitation events must be as variable as occurs in nature, and it is necessary to reproduce a sufficient number of real and consecutive rain events in order to be correlated with each other.

Furthermore, a characterization of the polluting loads, upstream and downstream of the system, is necessary; in fact, it has been seen that the removal mechanisms are not the same for everyone. Finally, it is required that greater attention is paid to the impact of the quality of underground waters, as well as those on the surface. Another very critical aspect is the durability of the functional objectives of the permeable pavement. While on the one hand, it is not disputed that they are designed with good permeability and that this is unquestionably a property that brings countless advantages, on the other hand, it is also true that this property is reduced or lost in the short- and medium-term, in some cases, due to the progressive clogging of the PPS layers without the possibility of reversibility (medium term), and in some cases, due to very harsh winter weather conditions that make the pavement a waterproof slab (short term). The question that derives is: what is the use of investing in a permeable pavement if, after a short time, it will behave exactly like a waterproof pavement?

In our opinion, this represents great criticality, as it creates enormous difficulty in proposing permeable pavement as a reliable system to which everyone should strive to use. These systems have great potential and converge on the common goal of a sustainable urban system, but as long as the advantages and disadvantages of such techniques are not shared in literature, such systems will never find much space in practical applications.

# 5. Conclusions

The aim of this work was to provide a critical review of the studies conducted on permeable pavement systems highlighting a critical point: scale reproducibility. In fact, in many cases, the results of the studies conducted are discordant with those expected and with studies conducted on the same aspect and on the same type of PP, which often provide completely different results. The following is a summary of the main missing studies that could be useful to researchers to bridge the shortcomings of the existing studies:

• studies with a longer analysis time and that are conducted outdoors, exposed to real climatic and anthropic conditions;   
• studies with a more reliable and variable reproduction of precipitation events;   
• studies with characterization of the polluting loads analyzed;   
• studies with greater attention paid to the impact on the quality of underground waters, as well as on surface waters;   
• studies with more insights on the possibility of making PP reversible.

Permeable pavement systems certainly have numerous advantages, however, if these are not accompanied by the suitable durability of the functional objectives, the problem will not be solved. For this reason, it is therefore important to reflect on the path to follow in order to progress in research on permeable pavement systems; this critical review is intended as an encouragement to go in the correct direction and not to continue to concentrate one’s efforts on themes already extensively investigated and discussed. If we all agree that PPS are a valid system, then the time has come to overcome the obstacles encountered and not to continue to retrace them by persevering in the mistakes of the past, albeit each time in a different way.

Summaries, such as this review, want to be a useful tool, both for researchers and designers, industries, and government agencies, to further promote the understanding and acceptance of PPs in addition to providing an extensive list of issues and problems on which to focus in the future.

Author Contributions: The authors equally contributed to the present research and to the preparation of the paper. All authors have read and agreed to the published version of the manuscript.

Funding: This research received no external funding.

Institutional Review Board Statement: Not applicable.

Informed Consent Statement: Not applicable.

Acknowledgments: This work was related to the D.D. 407 of 27 February 2018 AIM—Attrazione e Mobilità Internazionale, issued by the Italian Ministry of Education, University, and Research in implementation of Action I.2 Mobilità dei Ricercatori Asse I—PON R&I 2014–2020, taking into account the written amendment procedure of the PON R&I 2014–2020, pursuant to articles 30 and 90of Regulation (EU) 1303/2013 started on 21 February 2018, as well as the relevant implementation regulations.

Conflicts of Interest: The authors declare no conflict of interest.

# References

1. Liu, Y.; Bralts, V.F.; Engel, B.A. Evaluating the effectiveness of management practices on hydrology and water quality at watershed scale with a rainfall-runoff model. Sci. Total Environ. 2015, 511, 298–308. [CrossRef]   
2. Hoghooghi, N.; Golden, H.E.; Bledsoe, B.P.; Barnhart, B.L.; Brookes, A.F.; Djang, K.S.; Halama, J.J.; McKane, R.B.; Nietch, C.T.; Pettus, P. Cumulative Effects of Low Impact Development on Watershed Hydrology in a Mixed Land-Cover System. Water 2018, 10, 991. [CrossRef]   
3. Hensen, B.; Lange, J.; Jackisch, N.; Zieger, F.; Olsson, O.; Kümmerer, K. Entry of biocides and their transformation products into groundwater via urban stormwater infiltration systems. Water Res. 2018, 144, 413–423. [CrossRef] [PubMed]   
4. Ulrich, U.; Lange, J.; Pfannerstill, M.; Loose, L.; Fohrer, N. Hydrological tracers, the herbicide metazachlor and its transformation products in a retention pond during transient flow conditions. Environ. Sci. Pollut. Res. Int. 2019, 26, 26706–26720. [CrossRef] [PubMed]   
5. Pfannerstill, M.; Kühling, I.; Hugenschmidt, C.; Trepel, M.; Fohrer, N. Reactive ditches: A simple approach to implement denitrifying wood chip bioreactors to reduce nitrate exports into aquatic ecosystems? Environ. Earth Sci. 2016, 75, 1063. [CrossRef]   
6. Collins, K.; Hunt, W.; Hathaway, J. Side-by-side comparison of nitrogen species removal for four types of permeable pavement and standard asphalt in eastern North Carolina. J. Hydrol. Eng. 2010, 15, 512–521. [CrossRef]   
7. Fassman, E.; Blackbourn, S. Urban runoff mitigation by a permeable pavement system over impermeable soils. J. Hydrol. Eng. 2010, 15, 475–485. [CrossRef]   
8. Chen, L.M.; Chen, J.W.; Lecher, T.; Chen, T.H.; Davidson, P. Assessment of clogging of permeable pavements by measuring change in permeability. Sci. Total Environ. 2020. [CrossRef] [PubMed]   
9. Drake, J.; Bradford, A. Assessing the potential for rehabilitation of surface permeability using regenerative air and vacuum Sweeping Trucks. J. Water Manag. Modeling 2013, 21. [CrossRef]   
10. Niu, Z.G.; Lv, Z.W.; Zhang, Y.; Cui, Z.Z. Stormwater infiltration and surface runoff pollution reduction performance of permeable pavement layers. Environ. Sci. Pollut. Res. 2016, 23, 2576–2587. [CrossRef]   
11. Fassman, E.; Blackbourn, S. Permeable Pavement Preformance over 3 Years of Monitoring. In Proceedings of the Low Impact Development 2010: Redefining Water in the City, San Francisco, CA, USA, 11–14 April 2010; pp. 152–165.   
12. Starke, P.; Göbel, P.; Coldewey, W. Urban evaporation rates for water-permeable pavements. Water Sci. Technol. 2010, 62, 1161–1169. [CrossRef] [PubMed]   
13. Starke, P.; Göbel, P.; Coldewey, W. Effects on evaporation rates from different water-permeable pavement designs. Water Sci. Technol. 2011, 63, 2619–2627. [CrossRef] [PubMed]   
14. Hou, K.; Roseen, R.; Ballestero, T.; Briggs, J.; Houle, J. Examination of pervious concrete and porous asphalt pavements performance for stormwater management in northern climates. In Proceedings of the Low Impact Development 2010, San Francisco, CA, USA, 11–14 April 2010; pp. 1281–1298.   
15. Liu, W.; Feng, Q.; Chen, W.; Deo, R.C. Stormwater runoff and pollution retention performances of permeable pavements and the effects of structural factors. Environ. Sci. Pollut. Res. 2020. [CrossRef]   
16. Zhang, J.W.; Liu, J.; Jin, J.R.; Li, T. Performance Assessment of Permeable Interlocking Concrete Pavement Facility Structure. Huan Jing Ke Xue 2020, 41, 750–755. [CrossRef] [PubMed]   
17. Tota-Maharaj, K.; Scholz, M. Efficiency of permeable pavement systems for the removal of urban runoff pollutants under varying environmental conditions. Environ. Prog. Sustain. Energy 2010, 29, 358–369. [CrossRef]   
18. Kachchu, M.; Lucke, T.; Boogaard, F. Preliminary investigation into the pollution reduction performance of swales used in a stormwater treatment train. Water Sci. Technol. 2014. [CrossRef]   
19. Li, H.; Li, Z.; Zhang, X.; Li, Z.; Liu, D.; Li, T.; Zhang, Z. The effect of different surface materials on runoff quality in permeable pavement systems. Environ. Sci. Pollut. Res. 2017. [CrossRef] [PubMed]   
20. Selbig, W.R.; Buer, N.; Danz, M.E. Stormwater-quality performance of lined permeable pavement systems. J. Environ. Manag. 2019. [CrossRef]   
21. Liu, J.; Yan, H.; Liao, Z.; Zhang, K.; Schmidt, A.R.; Tao, T. Laboratory analysis on the surface runoff pollution reduction performance of permeable pavements. Sci. Total Environ. 2019, 691, 1–8. [CrossRef]   
22. Drake, J.; Bradford, A.; Van Seters, T. Stormwater quality of spring summer-fall effluent from three partial-infiltration permeable pavement systems and conventional asphalt pavement. J. Environ. Manag. 2014, 139, 69–79. [CrossRef]   
23. Kuruppu, U.; Rahman, A.; Sathasivan, A. Enhanced denitrification by design modifications to the standard permeable pavement structure. J. Clean. Prod. 2019, 237, 117721. [CrossRef]   
24. Razzaghmanesh, M.; Borst, M. Investigation clogging dynamic of permeable pavement systems using embedded sensors. J. Hydrol. 2018, 557, 887–896. [CrossRef]   
25. Chu, L.; Fwa, T.F. Evaluation of surface infiltration performance of permeable pavements. J. Environ. Manag. 2019, 238, 136–143. [CrossRef]   
26. Bariši´c, I.; Netinger Grubeša, I.; Dokšanovi´c, T.; Zvonari´c, M. Influence of Clogging and Unbound Base Layer Properties on Pervious Concrete Drainage Characteristics. Materials 2020, 13, 2455. [CrossRef]   
27. Kamali, M.; Delkash, M.; Tajrishy, M. Evaluation of permeable pavement responses to urban surface runoff. J. Environ. Manag. 2017, 187, 43–53. [CrossRef]   
28. Guo, X.; Zhang, J.; Zhou, B.; Liu, W.; Pei, J.; Guan, Y. Sponge roads: The permeable asphalt pavement structures based on rainfall characteristics in central plains urban agglomeration of China. Water Sci. Technol. 2019, 80, 1740–1750. [CrossRef] [PubMed]   
29. Fathollahi, A.; Coupe, S.J.; El-Sheikh, A.H.; Sañudo-Fontaneda, L.A. The biosorption of mercury by permeable pavement biofilms in stormwater attenuation. Sci. Total Environ. 2020, 741, 140411. [CrossRef] [PubMed]   
30. Skaf, M.; Pasquini, E.; Revilla-Cuesta, V.; Ortega-López, V. Performance and Durability of Porous Asphalt Mixtures Manufactured Exclusively with Electric Steel Slags. Materials 2019, 12, 3306. [CrossRef] [PubMed]   
31. Bäckström, M.; Berström, A. Draining function of porous asphalt during snowmelt and temporary freezing. Can. J. Civ. Eng. 2000, 27, 594–598. [CrossRef]   
32. Boving, T.; Stolt, M.; Augenstern, J.; Brosnan, B. Potential for localized groundwater contamination in a porous pavement parking lot setting in Rhode Island. Environ. Geol. 2008, 55, 571–582. [CrossRef]   
33. Drake, J.A.P.; Bradford, A.; Marsalek, J. Review of environmental performance of permeable pavement systems: State of the knowledge. Water Qual. Res. J. Can. 2013, 48, 203–222. [CrossRef]